/*************************************************************************
*    UrBackup - Client/Server backup system
*    Copyright (C) 2011  Martin Raiber
*
*    This program is free software: you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation, either version 3 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/
#pragma once
#include <string>
#include <map>
#include <vector>

std::string ConvertToUTF8(const std::wstring &input);
std::wstring ConvertToUnicode(const std::string &str);

class CFileSettingsReader
{
public:
	CFileSettingsReader(std::string pFile);

	virtual bool getValue(std::string key, std::string *value);
	virtual bool getValue(std::wstring key, std::wstring *value);

	std::vector<std::wstring> getKeys(void);

private:
	
	std::map<std::wstring,std::wstring> mSettingsMap;
};